/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class VanillaResourceManager
implements ResourceManager,
Closeable {
    private final PackType TYPE = PackType.CLIENT_RESOURCES;
    private final Map<String, PackResources> packs = new HashMap<String, PackResources>();

    public VanillaResourceManager(PackRepository repository) {
        Pack m;
        Pack v = repository.m_10507_("vanilla");
        if (v != null) {
            this.packs.put("vanilla", v.m_10445_());
        }
        if ((m = repository.m_10507_("mod_resources")) != null) {
            this.packs.put("mod_resources", m.m_10445_());
        }
    }

    public Set<String> m_7187_() {
        return this.packs.keySet();
    }

    public boolean m_7165_(ResourceLocation location) {
        return this.packs.values().stream().anyMatch(p -> p.m_7211_(this.TYPE, location));
    }

    public List<Resource> m_7396_(ResourceLocation p_10730_) throws IOException {
        throw new IOException("Operation not supported");
    }

    public Collection<ResourceLocation> m_6540_(String p_10726_, Predicate<String> p_10727_) {
        return Collections.emptySet();
    }

    public Stream<PackResources> m_7536_() {
        return this.packs.values().stream();
    }

    public Resource m_142591_(final ResourceLocation location) throws IOException {
        for (final PackResources p : this.packs.values()) {
            if (!p.m_7211_(this.TYPE, location)) continue;
            return new Resource(){
                @Nullable
                InputStream inputStream;

                public void close() throws IOException {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }

                public ResourceLocation m_7843_() {
                    return location;
                }

                public InputStream m_6679_() {
                    try {
                        this.inputStream = p.m_8031_(VanillaResourceManager.this.TYPE, location);
                    }
                    catch (IOException ioexception) {
                        throw new UncheckedIOException("Could not get client resource from vanilla pack", ioexception);
                    }
                    return this.inputStream;
                }

                public boolean m_142564_() {
                    return false;
                }

                @Nullable
                public <T> T m_5507_(MetadataSectionSerializer<T> p_143773_) {
                    return null;
                }

                public String m_7816_() {
                    return location.toString();
                }
            };
        }
        throw new FileNotFoundException(location.toString());
    }

    @Override
    public void close() {
        this.packs.values().forEach(PackResources::close);
    }
}

